/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.event;

import com.oblivioussp.spartanweaponry.ModSpartanWeaponry;
import com.oblivioussp.spartanweaponry.api.IWeaponPropertyContainer;
import com.oblivioussp.spartanweaponry.api.weaponproperty.IPropertyCallback;
import com.oblivioussp.spartanweaponry.api.weaponproperty.WeaponProperty;
import com.oblivioussp.spartanweaponry.entity.projectile.EntityThrownWeapon;
import com.oblivioussp.spartanweaponry.init.EnchantmentRegistrySW;
import com.oblivioussp.spartanweaponry.item.IBlockingWeapon;
import com.oblivioussp.spartanweaponry.item.ItemQuiverBase;
import com.oblivioussp.spartanweaponry.item.ItemThrowingWeapon;
import com.oblivioussp.spartanweaponry.util.AdvancementTrigger;
import com.oblivioussp.spartanweaponry.util.ConfigHandler;
import com.oblivioussp.spartanweaponry.util.Log;
import com.oblivioussp.spartanweaponry.util.QuiverHelper;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityVelocity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryTable;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LootingLevelEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

@Mod.EventBusSubscriber
public class EventHandlerCommon {
    public static Random rand = new Random();
    public static int tickCounter = 0;

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent ev) {
        DamageSource source = ev.getSource();
        float dmgDealt = ev.getAmount();
        EntityLivingBase victim = ev.getEntityLiving();
        if (ModSpartanWeaponry.debugMode) {
            Log.info("Damage: Entity: " + victim.func_145748_c_().func_150261_e() + " Armour value: " + victim.func_70658_aO() + " Damage value: " + dmgDealt + " Source: " + source.field_76373_n + " BypassesArmour: " + source.func_76363_c());
        }
        if (dmgDealt == 0.0f || source.func_76352_a() || source.func_76347_k() || source.func_94541_c() || source.func_82725_o() || !source.func_76355_l().equals("player") && !source.func_76355_l().equals("mob")) {
            return;
        }
        if (source.func_76364_f() == source.func_76346_g() && source.func_76346_g() instanceof EntityLivingBase && victim != null) {
            IWeaponPropertyContainer container;
            EntityLivingBase attacker = (EntityLivingBase)source.func_76346_g();
            ItemStack stack = attacker.func_184614_ca();
            ItemStack victimStack = victim.func_184614_ca();
            if (!stack.func_190926_b()) {
                if (stack.func_77973_b() instanceof IWeaponPropertyContainer) {
                    IPropertyCallback callback;
                    container = (IWeaponPropertyContainer)stack.func_77973_b();
                    float directDamage = container.getDirectAttackDamage();
                    List<WeaponProperty> props = container.getAllWeaponProperties();
                    for (WeaponProperty prop : props) {
                        callback = prop.getCallback();
                        if (callback == null) continue;
                        dmgDealt = callback.modifyDamageDealt(container.getMaterialEx(), dmgDealt, directDamage + 1.0f, source, attacker, victim);
                    }
                    for (WeaponProperty prop : container.getMaterialEx().getAllWeaponProperties()) {
                        callback = prop.getCallback();
                        if (callback == null) continue;
                        dmgDealt = callback.modifyDamageDealt(container.getMaterialEx(), dmgDealt, directDamage + 1.0f, source, attacker, victim);
                    }
                }
                if (stack.func_77973_b() instanceof ItemThrowingWeapon && stack.func_77942_o() && stack.func_77978_p().func_74762_e("AmmoUsed") >= ((ItemThrowingWeapon)stack.func_77973_b()).getMaxAmmo(stack)) {
                    dmgDealt = 1.0f;
                }
            }
            if (!victimStack.func_190926_b() && victimStack.func_77973_b() instanceof IWeaponPropertyContainer) {
                IPropertyCallback callback;
                container = (IWeaponPropertyContainer)victimStack.func_77973_b();
                List<WeaponProperty> props = container.getAllWeaponProperties();
                for (WeaponProperty prop : props) {
                    callback = prop.getCallback();
                    if (callback == null) continue;
                    dmgDealt = callback.modifyDamageTaken(container.getMaterialEx(), dmgDealt, source, attacker, victim);
                }
                for (WeaponProperty prop : container.getMaterialEx().getAllWeaponProperties()) {
                    callback = prop.getCallback();
                    if (callback == null) continue;
                    dmgDealt = callback.modifyDamageTaken(container.getMaterialEx(), dmgDealt, source, attacker, victim);
                }
            }
            if (dmgDealt != ev.getAmount()) {
                if (!attacker.field_70170_p.field_72995_K) {
                    if (dmgDealt > ev.getAmount()) {
                        ((WorldServer)attacker.field_70170_p).func_175739_a(EnumParticleTypes.CRIT_MAGIC, victim.field_70165_t, victim.field_70163_u + (double)(victim.field_70131_O / 2.0f), victim.field_70161_v, 16, 0.2, 0.2, 0.2, 0.0, new int[0]);
                    } else if (dmgDealt < ev.getAmount()) {
                        ((WorldServer)attacker.field_70170_p).func_175739_a(EnumParticleTypes.SMOKE_LARGE, victim.field_70165_t, victim.field_70163_u + (double)(victim.field_70131_O / 2.0f), victim.field_70161_v, 16, 0.2, 0.2, 0.2, 0.0, new int[0]);
                    }
                }
                ev.setAmount(dmgDealt);
            }
        }
    }

    @SubscribeEvent
    public static void attackEvent(LivingAttackEvent ev) {
        ItemStack activeStack;
        EntityPlayer player;
        if (ev.getEntityLiving() instanceof EntityPlayer && (player = (EntityPlayer)ev.getEntityLiving()).func_184587_cr() && !player.func_184607_cu().func_190926_b() && (activeStack = player.func_184607_cu()).func_77973_b() instanceof IBlockingWeapon) {
            IBlockingWeapon weapon = (IBlockingWeapon)activeStack.func_77973_b();
            DamageSource source = ev.getSource();
            boolean damageItem = false;
            if (!(!weapon.canBlockMelee() || source.func_94541_c() || source.func_76347_k() || source.func_82725_o() || source.func_76352_a() || source.func_76363_c())) {
                Entity trueSourceEntity = source.func_76346_g();
                double mX = trueSourceEntity.field_70159_w;
                double mY = trueSourceEntity.field_70181_x;
                double mZ = trueSourceEntity.field_70179_y;
                if (trueSourceEntity instanceof EntityLivingBase) {
                    ((EntityLivingBase)source.func_76346_g()).func_70653_a((Entity)player, 0.3f, player.field_70165_t - source.func_76346_g().field_70165_t, player.field_70161_v - source.func_76346_g().field_70161_v);
                }
                if (trueSourceEntity instanceof EntityPlayerMP && trueSourceEntity.field_70133_I) {
                    ((EntityPlayerMP)trueSourceEntity).field_71135_a.func_147359_a((Packet)new SPacketEntityVelocity(trueSourceEntity));
                    trueSourceEntity.field_70133_I = false;
                    trueSourceEntity.field_70159_w = mX;
                    trueSourceEntity.field_70181_x = mY;
                    trueSourceEntity.field_70179_y = mZ;
                }
                damageItem = true;
            } else if (weapon.canBlockProjectiles() && ev.getSource().func_76352_a()) {
                damageItem = true;
            }
            if (damageItem) {
                ItemStack copy = activeStack.func_77946_l();
                int itemDamage = 1 + MathHelper.func_76141_d((float)ev.getAmount());
                activeStack.func_77972_a(itemDamage, (EntityLivingBase)player);
                if (activeStack.func_190926_b()) {
                    EnumHand activeHand = player.func_184600_cs();
                    ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)player, (ItemStack)copy, (EnumHand)activeHand);
                    player.func_70669_a(copy);
                    if (activeHand == EnumHand.MAIN_HAND) {
                        player.func_184201_a(EntityEquipmentSlot.MAINHAND, ItemStack.field_190927_a);
                    } else if (activeHand == EnumHand.OFF_HAND) {
                        player.func_184201_a(EntityEquipmentSlot.OFFHAND, ItemStack.field_190927_a);
                    }
                    activeStack = ItemStack.field_190927_a;
                }
                player.field_70170_p.func_184148_a((EntityPlayer)null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187721_dT, SoundCategory.PLAYERS, 0.8f, 0.8f);
                ev.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onCraftEvent(PlayerEvent.ItemCraftedEvent ev) {
        if (ev.player instanceof EntityPlayerMP) {
            AdvancementTrigger.CRAFT_ITEM.trigger((EntityPlayerMP)ev.player, ev.crafting.func_77973_b());
        }
    }

    @SubscribeEvent
    public static void onLootLevel(LootingLevelEvent ev) {
        Entity e = ev.getDamageSource().func_76364_f();
        if (e instanceof EntityThrownWeapon) {
            EntityThrownWeapon thrownWeapon = (EntityThrownWeapon)e;
            int luckLevel = EnchantmentHelper.func_77506_a((Enchantment)EnchantmentRegistrySW.THROWING_LUCK, (ItemStack)thrownWeapon.getWeaponStack());
            ev.setLootingLevel(luckLevel);
        }
    }

    @SubscribeEvent
    public static void onEquipmentChange(LivingEquipmentChangeEvent ev) {
        if ((ev.getSlot() == EntityEquipmentSlot.MAINHAND || ev.getSlot() == EntityEquipmentSlot.OFFHAND) && ev.getEntityLiving() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)ev.getEntityLiving();
            ItemStack fromStack = ev.getFrom();
            ItemStack toStack = ev.getTo();
            EntityEquipmentSlot oppositeHand = ev.getSlot() == EntityEquipmentSlot.OFFHAND ? EntityEquipmentSlot.MAINHAND : EntityEquipmentSlot.OFFHAND;
            ItemStack oppositeStack = player.func_184582_a(oppositeHand);
            if (!toStack.func_77969_a(fromStack)) {
                String regName;
                if (!oppositeStack.func_190926_b()) {
                    boolean toStackBlacklisted = false;
                    String toName = toStack.func_77973_b().getRegistryName().toString();
                    if (ConfigHandler.quiverBowBlacklist.contains(toName)) {
                        toStackBlacklisted = true;
                    }
                    for (QuiverHelper.IQuiverInfo quiverInfo : QuiverHelper.info) {
                        if (!quiverInfo.isWeapon(fromStack) || quiverInfo.isWeapon(toStack) && !toStackBlacklisted || !quiverInfo.isAmmo(oppositeStack)) continue;
                        ItemStack quiver = QuiverHelper.findFirstOfType(player, quiverInfo);
                        EventHandlerCommon.placeAmmoIntoQuiver(player, quiver, oppositeHand);
                        oppositeStack = player.func_184582_a(oppositeHand);
                        if (!oppositeStack.func_190926_b()) continue;
                        NBTTagCompound nbt = quiver.func_190925_c("offhandMoved");
                        if (nbt == null) break;
                        String itemId = nbt.func_74779_i("id");
                        int itemSlot = nbt.func_74762_e("slot");
                        ItemStack offhandStack = player.field_71071_by.func_70301_a(itemSlot);
                        if (offhandStack.func_77973_b().getRegistryName().toString().equals(itemId)) {
                            player.func_184201_a(oppositeHand, offhandStack);
                            player.field_71071_by.func_70299_a(itemSlot, ItemStack.field_190927_a);
                        }
                        quiver.func_77978_p().func_82580_o("offhandMoved");
                        break;
                    }
                }
                if (ConfigHandler.quiverBowBlacklist.contains(regName = toStack.func_77973_b().getRegistryName().toString())) {
                    return;
                }
                for (QuiverHelper.IQuiverInfo quiverInfo : QuiverHelper.info) {
                    ItemStack quiver;
                    if (!quiverInfo.isWeapon(toStack) || (quiver = QuiverHelper.findFirstOfType(player, quiverInfo)).func_190926_b()) continue;
                    IItemHandler quiverHandler = (IItemHandler)quiver.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
                    boolean isQuiverEmpty = true;
                    for (int i = 0; i < quiverHandler.getSlots(); ++i) {
                        ItemStack arrowStack = quiverHandler.getStackInSlot(i);
                        if (arrowStack.func_190926_b()) continue;
                        isQuiverEmpty = false;
                        break;
                    }
                    if (!(isQuiverEmpty || oppositeStack.func_190926_b() || quiverInfo.isAmmo(oppositeStack))) {
                        int emptySlot = -1;
                        for (int i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
                            ItemStack playerStack = (ItemStack)player.field_71071_by.field_70462_a.get(i);
                            if (!playerStack.func_190926_b()) continue;
                            emptySlot = i;
                            break;
                        }
                        if (emptySlot != -1) {
                            String itemId = oppositeStack.func_77973_b().getRegistryName().toString();
                            NBTTagCompound nbt = quiver.func_190925_c("offhandMoved");
                            nbt.func_74778_a("id", itemId);
                            nbt.func_74768_a("slot", emptySlot);
                            player.field_71071_by.func_70299_a(emptySlot, oppositeStack);
                            player.func_184201_a(oppositeHand, ItemStack.field_190927_a);
                        }
                    }
                    if (player.func_184582_a(oppositeHand).func_190926_b()) {
                        EventHandlerCommon.takeAmmoFromQuiver(player, quiver, oppositeHand);
                    }
                    if ((oppositeStack = player.func_184582_a(oppositeHand)).func_190926_b()) continue;
                    break;
                }
            }
        }
    }

    protected static void placeAmmoIntoQuiver(EntityPlayer player, ItemStack quiver, EntityEquipmentSlot oppositeHandSlot) {
        if (!quiver.func_190926_b() && quiver.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
            IItemHandler quiverHandler = (IItemHandler)quiver.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            ItemStack arrowStack = player.func_184582_a(oppositeHandSlot);
            for (int j = 0; j < quiverHandler.getSlots() && !(arrowStack = quiverHandler.insertItem(j, arrowStack, false)).func_190926_b(); ++j) {
            }
            player.func_184201_a(oppositeHandSlot, arrowStack);
        }
    }

    protected static void takeAmmoFromQuiver(EntityPlayer player, ItemStack quiver, EntityEquipmentSlot oppositeHandSlot) {
        if (!quiver.func_190926_b() && quiver.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
            IItemHandler quiverHandler = (IItemHandler)quiver.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            ItemStack arrowStack = ItemStack.field_190927_a;
            for (int j = 0; j < quiverHandler.getSlots(); ++j) {
                arrowStack = quiverHandler.extractItem(j, 64, false);
                if (arrowStack.func_190926_b()) continue;
                player.func_184201_a(oppositeHandSlot, arrowStack);
                break;
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerPickupEvent(EntityItemPickupEvent ev) {
        int beforeCount;
        ItemStack pickedUpStack = ev.getItem().func_92059_d().func_77946_l();
        int afterCount = beforeCount = pickedUpStack.func_190916_E();
        EntityPlayer player = ev.getEntityPlayer();
        List<ItemStack> quivers = QuiverHelper.findValidQuivers(player);
        if (!quivers.isEmpty()) {
            for (ItemStack quiver : quivers) {
                if (!pickedUpStack.func_190926_b() && !quiver.func_190926_b() && quiver.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null) && ((ItemQuiverBase)quiver.func_77973_b()).isAmmoValid(pickedUpStack, quiver) && quiver.func_77942_o() && quiver.func_77978_p().func_74767_n("ammoCollect")) {
                    IItemHandler quiverHandler = (IItemHandler)quiver.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
                    for (int i = 0; i < quiverHandler.getSlots() && !(pickedUpStack = quiverHandler.insertItem(i, pickedUpStack, false)).func_190926_b(); ++i) {
                    }
                }
                if (!pickedUpStack.func_190926_b()) continue;
                break;
            }
            if ((afterCount = pickedUpStack.func_190916_E()) < beforeCount) {
                player.func_71001_a((Entity)ev.getItem(), beforeCount - afterCount);
                ev.getItem().func_92059_d().func_190920_e(afterCount);
                player.field_70170_p.func_184148_a((EntityPlayer)null, ev.getItem().field_70165_t, ev.getItem().field_70163_u, ev.getItem().field_70161_v, SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, (rand.nextFloat() - rand.nextFloat()) * 0.7f + 0.0f);
            }
        }
        if (pickedUpStack.func_77973_b() instanceof ItemThrowingWeapon) {
            boolean pickUpAsNewItem = true;
            boolean removeItems = false;
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                ItemStack slotStack = player.field_71071_by.func_70301_a(i);
                if (!ItemStack.func_185132_d((ItemStack)slotStack, (ItemStack)pickedUpStack) || !pickedUpStack.func_77942_o() || !slotStack.func_77942_o() || !pickedUpStack.func_77978_p().func_186857_a("UUID").equals(slotStack.func_77978_p().func_186857_a("UUID")) || !(pickedUpStack.func_77973_b() instanceof ItemThrowingWeapon)) continue;
                int maxAmmo = ((ItemThrowingWeapon)slotStack.func_77973_b()).getMaxAmmo(slotStack);
                int currentAmmo = maxAmmo - slotStack.func_77978_p().func_74762_e("AmmoUsed");
                boolean currentNotOriginalStack = !slotStack.func_77978_p().func_74767_n("Original");
                boolean pickedUpOriginalStack = pickedUpStack.func_77978_p().func_74767_n("Original");
                if (currentAmmo >= maxAmmo && (!currentNotOriginalStack || !pickedUpOriginalStack)) continue;
                int itemDamage = slotStack.func_77952_i() + pickedUpStack.func_77952_i();
                if (itemDamage > slotStack.func_77958_k()) {
                    player.func_70669_a(pickedUpStack);
                    itemDamage -= slotStack.func_77958_k() + 1;
                } else {
                    int pickupMaxAmmo = ((ItemThrowingWeapon)pickedUpStack.func_77973_b()).getMaxAmmo(pickedUpStack);
                    currentAmmo += pickupMaxAmmo - pickedUpStack.func_77978_p().func_74762_e("AmmoUsed");
                    int newMaxAmmo = Math.max(maxAmmo, pickupMaxAmmo);
                    currentAmmo = MathHelper.func_76125_a((int)currentAmmo, (int)0, (int)newMaxAmmo);
                    slotStack.func_77978_p().func_74768_a("AmmoUsed", newMaxAmmo - currentAmmo);
                    if (currentNotOriginalStack && pickedUpOriginalStack) {
                        slotStack.func_77978_p().func_74757_a("Original", pickedUpOriginalStack);
                        if (pickedUpStack.func_77948_v()) {
                            Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)pickedUpStack);
                            EnchantmentHelper.func_82782_a((Map)enchantments, (ItemStack)slotStack);
                        }
                    }
                }
                slotStack.func_77964_b(itemDamage);
                pickUpAsNewItem = false;
                removeItems = true;
                break;
            }
            if (pickUpAsNewItem) {
                removeItems = player.field_71071_by.func_70441_a(pickedUpStack);
            }
            if (removeItems) {
                player.func_71001_a((Entity)ev.getItem(), 1);
                player.field_70170_p.func_184148_a((EntityPlayer)null, ev.getItem().field_70165_t, ev.getItem().field_70163_u, ev.getItem().field_70161_v, SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, (rand.nextFloat() - rand.nextFloat()) * 0.7f + 0.0f);
                ev.getItem().func_92059_d().func_190920_e(0);
            }
        }
    }

    @SubscribeEvent
    public static void onLootTableLoad(LootTableLoadEvent ev) {
        if (ev.getName().toString().equals("minecraft:chests/village_blacksmith")) {
            LootEntryTable entry = new LootEntryTable(new ResourceLocation("spartanweaponry", "inject/village_blacksmith"), 1, 1, new LootCondition[0], "spartanweaponry_inject_entry");
            LootPool pool = new LootPool(new LootEntry[]{entry}, new LootCondition[0], new RandomValueRange(1.0f), new RandomValueRange(0.0f, 1.0f), "spartanweaponry_inject_pool");
            ev.getTable().addPool(pool);
        }
    }

    @SubscribeEvent
    public static void handleAnvilUpdate(AnvilUpdateEvent ev) {
        ItemStack left = ev.getLeft();
        ItemStack right = ev.getRight();
        if (left.func_77973_b() instanceof ItemThrowingWeapon && left.func_77942_o() && left.func_77978_p().func_74767_n("Original") && left.func_185136_b(right)) {
            ItemThrowingWeapon throwingWeapon = (ItemThrowingWeapon)left.func_77973_b();
            int leftAmmo = left.func_77978_p().func_74762_e("AmmoUsed");
            int rightAmmo = right.func_77978_p().func_74762_e("AmmoUsed");
            if (leftAmmo == 0) {
                return;
            }
            int maxAmmo = ((ItemThrowingWeapon)left.func_77973_b()).getMaxAmmo(left);
            int durability = left.func_77952_i() + right.func_77952_i();
            int combinedAmmo = MathHelper.func_76125_a((int)(maxAmmo - leftAmmo + (maxAmmo - rightAmmo)), (int)0, (int)throwingWeapon.getMaxAmmo(left));
            if (durability > left.func_77958_k()) {
                combinedAmmo = Math.max(combinedAmmo - 1, 0);
                durability -= left.func_77958_k();
            }
            ItemStack resultStack = ev.getLeft().func_77946_l();
            resultStack.func_77978_p().func_74768_a("AmmoUsed", maxAmmo - combinedAmmo);
            resultStack.func_77964_b(durability);
            Map enchantmentMap = EnchantmentHelper.func_82781_a((ItemStack)left);
            int cost = 2;
            for (Map.Entry enchantment : enchantmentMap.entrySet()) {
                cost += ((Integer)enchantment.getValue()).intValue();
            }
            ev.setCost(cost);
            ev.setOutput(resultStack);
        }
    }
}

